package gov.va.med.mhv.integration.phr.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public abstract class PhrBaseDAOImpl extends DaoSupportImpl implements PhrBaseDAO{

	@Override
	public Long[] fetchFacilityInfoAndControlIdForUserProfileIdAndStation(String icn, String stationNumber){
		Long[] facilityInfoId = new Long[2];
		String sql = "select P.FACILITY_INFO_ID, P.PHR_FACILITY_CONTROL_ID FROM PHR_PATIENT_INFO P "+
			         "INNER JOIN FACILITY_INFO FI ON (FI.STATION_NUMBER = P.STATION_NUMBER AND FI.FACILITY_INFO_ID = P.FACILITY_INFO_ID) "+
			         "WHERE P.ICN = (SELECT ICN FROM PATIENT WHERE icn = ?) AND P.STATION_NUMBER = ?";

		PreparedStatement ps=null;
        Connection connection=null;
        try {
            connection=getConnection();
            ps = connection.prepareStatement(sql);
            int field=1;
            ps.setString(field++,icn);
            ps.setString(field++,stationNumber);
            ResultSet rs=ps.executeQuery();

    		if(rs!=null) {
                rs.next();
                facilityInfoId[0] = rs.getLong("FACILITY_INFO_ID");
                facilityInfoId[1] = rs.getLong("PHR_FACILITY_CONTROL_ID");
    		}

        } catch (SQLException e) {
            throw new RuntimeException(e);
        } finally {
           cleanup(connection, ps);
        }
        return facilityInfoId;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.dao.PhrBaseDAO#fetchFacilityInfoIds(java.lang.String)
	 */
	@Override
	public Hashtable<String,Long> fetchFacilityInfoIds(String icn){
		Hashtable<String,Long> ht = new Hashtable<String,Long>();
		String sql = "select P.STATION_NUMBER, P.FACILITY_INFO_ID FROM PHR_PATIENT_INFO P "+
			         "INNER JOIN FACILITY_INFO FI ON (FI.STATION_NUMBER = P.STATION_NUMBER AND FI.FACILITY_INFO_ID = P.FACILITY_INFO_ID) "+
			         "WHERE P.ICN = ?";

		PreparedStatement ps=null;
        Connection connection=null;
        try {
            connection=getConnection();
            ps = connection.prepareStatement(sql);
            int field=1;
            ps.setString(field++,icn);
            ResultSet rs=ps.executeQuery();

    		if(rs!=null) {
                while(rs.next()) {
                    ht.put(rs.getString("STATION_NUMBER"),rs.getLong("FACILITY_INFO_ID"));
                }
    		}

        } catch (SQLException e) {
            throw new RuntimeException(e);
        } finally {
           cleanup(connection, ps);
        }
        return ht;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.dao.PhrBaseDAO#fetchPhrFacilityControlIds(java.lang.String)
	 */
	@Override
	public Hashtable<String,Long> fetchPhrFacilityControlIds(String icn){
		Hashtable<String,Long> ht = new Hashtable<String,Long>();
		String sql = "select P.PHR_FACILITY_CONTROL_ID, P.STATION_NUMBER FROM PHR_PATIENT_INFO P "+
		               "INNER JOIN FACILITY_INFO FI ON (FI.STATION_NUMBER = P.STATION_NUMBER AND FI.FACILITY_INFO_ID = P.FACILITY_INFO_ID) "+
		               "WHERE P.ICN = ?";

		PreparedStatement ps=null;
        Connection connection=null;
        try {
            connection=getConnection();
            ps = connection.prepareStatement(sql);
            int field=1;
            ps.setString(field++,icn);
            ResultSet rs=ps.executeQuery();
    		if(rs!=null) {
                while(rs.next()) {
                    ht.put(rs.getString("STATION_NUMBER"),rs.getLong("PHR_FACILITY_CONTROL_ID"));
                }
    		}
        } catch (SQLException e) {
            throw new RuntimeException(e);
        } finally {
           cleanup(connection, ps);
        }
        return ht;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.dao.PhrBaseDAO#fetchPatientId(java.lang.String)
	 */
	@Override
	public Long fetchPatientId(String icn){
		Long result = null;
		String sql = "select DISTINCT(p.patient_id) from PATIENT_INFO p where p.icn = ?";

		PreparedStatement ps=null;
        Connection connection=null;
        try {
            connection=getConnection();
            ps = connection.prepareStatement(sql);
            int field=1;
            ps.setString(field,icn);
            ResultSet rs=ps.executeQuery();

    		if(rs!=null) {
                while(rs.next()) {
                    result = new Long(rs.getLong("PATIENT_ID"));
                }
    		}
        } catch (SQLException e) {
            throw new RuntimeException(e);
        } finally {
           cleanup(connection, ps);
        }
        return result;
	}
	
	public boolean isFieldTester(String icn, String accessRoleName) {
        String sql = "SELECT AR.NAME " +
					 "FROM ACCESS_ROLE AR, " +
					 "     USER_PROFILE_ACCESS_ROLE UPAR, " +
					 "     PATIENT P " +
					 "WHERE P.ICN = ? " +
					 "AND AR.NAME = ? " +
					 "AND UPAR.ACCESS_ROLE_ID  = AR.ACCESS_ROLE_ID " +
					 "AND UPAR.USER_PROFILE_ID = P.USER_PROFILE_USER_PROFILE_ID";
	    Connection connection = null;
	    PreparedStatement ps = null;
	    ResultSet rs = null;
	    boolean result = false;
	    
	    try {
	        connection=getConnection();
	        ps = connection.prepareStatement(sql);
	        ps.setString(1, icn);
	        ps.setString(2, accessRoleName);
	        rs = ps.executeQuery();            
	        if( rs.next() ) {
	        	//one row existed
	        	result = true;
	        }
	    } catch (SQLException e) {
	        throw new RuntimeException(e);
	    } finally {
	        cleanup(connection, rs,ps);
	        //closeConnection();
	    }
	    return result;
	}
	
}
